<?php
//vidi server

//Open db or create it on first run
if ($db=new SQLite3("vidi.sqlite",SQLITE3_OPEN_CREATE | SQLITE3_OPEN_READWRITE)){
        $db->query("CREATE TABLE IF NOT EXISTS vidi(id INTEGER PRIMARY KEY,tag VARCHAR(30),
            start INTEGER,end INTEGER, session INTEGER,note TEXT, entered INTEGER);

            CREATE TABLE IF NOT EXISTS sessions(id INTEGER PRIMARY KEY, created INTEGER,name VARCHAR (100),
             video VARCHAR(200),current INTEGER DEFAULT 0);
            ");
}
else {
    die("Couldn't open db");
}


switch ($_REQUEST['method']) {
    case 'sessions': //return list of available sessions
        $sql="SELECT id,name,video,created from sessions where video <>'' order by created DESC";
        $result=$db->query($sql);
        $json='[';
        while ($row=$result->fetchArray(SQLITE3_ASSOC)){
            $json.="{\"id\":$row[id],\"name\":\"".stripslashes($row[name])."\",\"video\":\"$row[video]\",\"created\":$row[created]},";
        }
        $json=rtrim($json,",")."]";
        sendjson($json);
        break;
    case 'session'://get info about current session; who tagged stuff
        $sql="SELECT name,id,video,current from sessions where current>0;";
        $results=$db->query($sql);
        $session=$results->fetchArray(SQLITE3_ASSOC);
        if (is_array($session)){
            $sql="SELECT tag from vidi where session=$session[id] GROUP BY tag ORDER by tag;";
            $results=$db->query($sql);
            $json='{"root":"'.$_SERVER["SCRIPT_NAME"].'","session":'.$session[id].',"name":"'.stripslashes($session[name]).'","video":"'.$session[video].'","mode":'.$session[current].',"tags":[';
            while ($row=$results->fetchArray(SQLITE3_ASSOC)){
                $json.='"'.$row[tag].'",';
            }
            $json=rtrim($json,",")."]}";         
        }
        else {
            $json='{"root":"'+$_ENV["SCRIPT_NAME"]+'","session":0,"name":"","video":"","mode":1,"tags":[]}';
        }
        sendjson($json);
        break;
    case 'createSession':
        //admin sets name, video for session
        //session marked current
        $sql="UPDATE sessions set current=0;";;
        $db->exec($sql);
        if ($_REQUEST["name"] && $_REQUEST["video"]){
            $sql="INSERT INTO sessions (name,video,current,created) values ('".$db->escapestring($_REQUEST["name"])."','$_REQUEST[video]',1,strftime('%s','now'));";
            $db->exec($sql);
            sendjson('{"method":"createSession","session":'.$db->lastInsertRowID().'}');
        }
        break;
    case 'broadcast':
        //given session marked current
        $sql="UPDATE sessions set current=0; UPDATE sessions set current=$_REQUEST[mode] where id=$_REQUEST[session];";
        $db->exec($sql);
        sendjson('{"method":"broadcast"}');
        break;
    case 'videos':
         // list videos in current directory
         $json='{"method":"videos","videos":[';
         $ar=array_merge(glob("*mov"),glob("*mpg"),glob("*m4v"),glob("*mp4")); 
         foreach ($ar as $file){
          $json.="\"$file\",";   
         }
         $json=rtrim($json,",")."]}";         
         sendjson($json);
        break;
    case 'tag':
        // given name, note, video, start; 
        $sql="insert into vidi (tag,session,start,note) values ('".$db->escapestring($_REQUEST[tag])."','$_REQUEST[session]',$_REQUEST[start],'".$db->escapestring($_REQUEST[note])."');";
        $db->exec($sql);
        //comment out header to view in browser
        sendjson('{"method":"tag","id":'.$db->lastInsertRowid().',"start":'.$_REQUEST['start'].',"note":"'.$_REQUEST['note'].'","tag":"'.$_REQUEST['tag'].'"}');
        break;
    case 'tags':
        // given a session, return an array of all tags
        $sql="select id,tag,start,note from vidi where session='$_REQUEST[session]' order by start, tag;";
        $results=$db->query($sql);
        $json="[";
        while ($row=$results->fetchArray(SQLITE3_ASSOC)) {
            $json.='{"id":'.$row[id].',"tag":"'.stripslashes($row["tag"]).'","start":'.$row[start].',"note":"'.stripslashes($row["note"]).'"},';
        }
        $json=rtrim($json,",")."]";         
        
        sendjson($json);
        break;
    //can do an all tags by video
    case 'dump':
        $sql="select tag,start,note,video,name,created from vidi inner join sessions where vidi.session=sessions.id order by video, created desc, start, tag;";
        $results=$db->query($sql);
        $json="[";
        while ($row=$results->fetchArray(SQLITE3_ASSOC)) {
                $json.='{"video":"'.stripslashes($row["video"]).'","name":"'.stripslashes($row["name"]).'","created":"'.stripslashes($row["created"]).'","tag":"'.stripslashes($row["tag"]).'","start":'.$row[start].',"note":"'.stripslashes($row["note"]).'"},';
        }
        $json=rtrim($json,",")."]";         

        sendjson($json);
        break;
    default:
        # code...
        break;
}

//$db will be automatically closed

function sendjson($json){
    //comment out header to see json in browser
    header('Content-type: application/json');
    echo $json;
}
    
?>

